import os
import io
#please, insert file Qt.py in this folder:
#Windows: C:\Program Files\Nuke10.0v1\lib\site-packages
#Linux: /usr/local/Nuke10.0v1/lib/python2.7/site-packages
#macOS: /Applications/Nuke10.0v2/Nuke10.0v2.app/Contents/Frameworks/Python.framework/Versions/2.7/lib/python2.7/site-packages

#Guide: fredrikaverpil.github.io/2016/07/25/developing-with-qt-py/
#nukepedia.com/prepare-for-qt5

from Qt import QtWidgets
from Qt import QtCompat
from Qt import QtGui


#insert the path where you can find the file interface.ui
file_interface = os.path.join("/Users/myName/Desktop/", "interface.ui")


#create the list of the knobs of the selected node
list = []
def create_list_knobs():

    del list[:]
    global node
    node = nuke.selectedNode()
    for knob in node.knobs().values():
        if (knob.label()!= "INVISIBLE" and knob.label()!= "panel dropped state"):
            if(knob.label()!=""):
                #list.append(knob.label() + " - " + knob.name())
                list.append(knob.name())
            else:
                list.append(knob.name())

    #order of the list
    list.sort()

create_list_knobs()


#------------------------------------------------------------------------------

class MyWindow(QtWidgets.QMainWindow):
    def __init__(self, parent=None):
        super(MyWindow, self).__init__(parent)
        self.main_widget = QtCompat.loadUi(file_interface)
        self.setCentralWidget(self.main_widget)
        self.load_ui()

    def load_ui(self):
        self.menu = self.main_widget.findChild(QtWidgets.QComboBox, "knob_ComboBox")
        self.menu.addItems(list)
        self.input = self.main_widget.findChild(QtWidgets.QLineEdit, "input_Text")
        self.label = self.main_widget.findChild(QtWidgets.QRadioButton, "label_radioButton")
        self.autolabel = self.main_widget.findChild(QtWidgets.QRadioButton, "autolabel_radioButton")
        self.button = self.main_widget.findChild(QtWidgets.QPushButton, "create_Button")
        self.button.clicked.connect(self.check_values)
        
        self.clear = self.main_widget.findChild(QtWidgets.QPushButton, "clear_Button")
        self.clear.clicked.connect(clear)

#HOW TO READ OR INTERACT WITH ELEMENTS IN THE PANEL
#QPushButton clicked
#button.clicked.connect(...)

#print QComboBox
#print self.menu.currentText()

#print QLineEdit
#print self.input.text()

    def check_values(self):
        if (self.label.isChecked()):
            knob = "label"
        else:
            knob = "autolabel"
    
        if (self.input.text() == "" and knob == "label"):
            value = "[value " + self.menu.currentText() + "]"
            node[knob].setValue(value)
        elif (self.input.text() == "" and knob == "autolabel"):
            value = self.menu.currentText()
            node['autolabel'].setValue("nuke.thisNode().name() + \"\\n\" + '(' + '" + value + "' + ' ' + str(nuke.thisNode()['" + value + "'].value()) + ')' ")
        elif (self.input.text() is not "" and knob == "autolabel"):
            value = self.input.text()
            node['autolabel'].setValue("nuke.thisNode().name() + \"\\n\" + '(' + '" + value + "' + ')' ")
        elif (self.input.text() is not "" and knob == "label"):
            value = self.input.text()
            node[knob].setValue(value)

#-----------------------------------------------------------------------

def show_window():
    global my_window
    my_window = MyWindow()
    my_window.show()

#clear the window
def clear():
    create_list_knobs()
    my_window.close()
    show_window()

show_window()