#http://www.comp-fu.com/2014/07/nuke-autolabel-magic/
#AUTOLABEL
n = nuke.selectedNodes()
for p in n:
    p['autolabel'].setValue("nuke.thisNode().name()")

#--------------------------------------------------------------------
#Try this with a Grade Node
n = nuke.selectedNodes()
for p in n:
    p['autolabel'].setValue("nuke.thisNode().name() + \"\\n\" + '(' + str(nuke.thisNode()['white'].value()) + ')' ")

#--------------------------------------------------------------------
#Try this with a Blur Node
n = nuke.selectedNodes()
for p in n:
    p['autolabel'].setValue("nuke.thisNode().name() + \"\\n\" + '(' + nuke.thisNode()['filter'].value() + ')' ")

#--------------------------------------------------------------------
#Try this with a Blur Node and print it out the name of the knob and the relative value
n = nuke.selectedNodes()
for p in n:
    p['autolabel'].setValue("nuke.thisNode().name() + \"\\n\" + '(' + str(nuke.thisNode()['size'].name()) + ' '  + str(nuke.thisNode()['size'].value()) + ')' ")

#--------------------------------------------------------------------
#Try this with the Grade node 'Grade1'
autoLabel = "nuke.thisNode().name() + (' lighter' if nuke.thisNode()['white'].value()>1 else ' darker')"
nuke.toNode("Grade1")['autolabel'].setValue(autoLabel)


#--------------------------------------------------------------------
#When you create a Transform node, every time you will see this autolabel
def TransformLabel():
    n = nuke.thisNode()
    if n.Class() == "Transform":
        autoLabel = n.name() + (' big' if n['scale'].value()>1 else ' small')
        if n['label'].value():
            autoLabel = autoLabel + '\n' + str(n['scale'].value())
        return autoLabel
 
nuke.addAutolabel(TransformLabel)
#--------------------------------------------------------------------




#--------------------------------------------------------------------
#Autolabel - Python panel
autolabel = nuke.getInput('Change autolabel', 'new autolabel')
if autolabel:
    for n in nuke.selectedNodes():
        n['autolabel'].setValue("nuke.thisNode().name() + \"\\n\" +  '(' + autolabel + ')' ")

#Label - Python panel
label = nuke.getInput('Change label', 'new label')
if label:
    for n in nuke.selectedNodes():
        n['label'].setValue(label)
#--------------------------------------------------------------------

